TITLE   'Charged, Conducting Sphere'			       { exa104a.pde }
SELECT     errlim=1e-4     ngrid=1     spectral_colors
COORDINATES   ycylinder( 'r', 'z')
VARIABLES   U
DEFINITIONS
   r1=0.1     r2=r1     r3=1
   eps=8.854e-12     Q=1e-9					{ Specified charge }
   E= -grad(U)     Em=magnitude(E)     D=eps*E     Dm=magnitude(D)
   Up=Q/(4*pi*eps*sqrt(r^2+z^2))		{ Potential of a point charge }
   Ep=-grad(Up)     Dp=eps*Ep     Dpm=magnitude(Dp)
   Qe=surf_integral( -2*normal(D), 'ellipsoid')
EQUATIONS
   div( D)=0
BOUNDARIES
region 'domain'
   start (r1,0)  natural(U)=0  line to (r3,0) 	
   natural(U)=Dpm    arc(center=0,0) to (0,r3)
   natural(U)=0  line to (0,r2)	value(U)=0
   arc(center=0,0) close 					{ Quarter ellipse }
feature
   start 'ellipsoid' (0,r2) arc(center=0,0) to (r1,0)
   start 'outer' (r3,0) arc(center=0,0) to (0,r3)
PLOTS
   contour(U) zoom(0,0, 2*r2,2*r2) report( globalmin(U))
   elevation(U) from (r1,0) to (r3,0)
   surface( Dm) zoom(0,0, 2*r2,2*r2)   vector( D) norm
   elevation( Dpm, normal(D)) on 'outer'				{ Test of Dn }
   elevation( 2*normal(D)) on 'outer'				{ ? Charge }
   elevation( -2*normal(D)) on 'ellipsoid'				{ ? Charge }
   report( Qe/(abs(globalmin(U))) )  as 'Capacitance'
   report( 4*pi*eps*r3*r1/(r3-r1)) as 'C_spherical'
END


